<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FieldLanguage extends Model 
{

    protected $table = 'lim_field_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_field_id', 'name', 'description');
    protected $visible = array('lim_language_id', 'lim_field_id', 'name', 'description');

    public function field()
    {
        return $this->belongsTo('App\Models\Fields', 'lim_field_id');
    }

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

}